/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.StoveTileEntity;
import vectorwing.farmersdelight.utils.MathUtils;

public class StoveBlock
extends HorizontalBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public StoveBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item usedItem = itemstack.func_77973_b();
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof StoveTileEntity) {
                StoveTileEntity stovetileentity = (StoveTileEntity)tile;
                Optional<CampfireCookingRecipe> optional = stovetileentity.findMatchingRecipe(itemstack);
                if (optional.isPresent()) {
                    if (!worldIn.field_72995_K && !stovetileentity.isStoveBlockedAbove() && stovetileentity.addItem(player.field_71075_bZ.field_75098_d ? itemstack.func_77946_l() : itemstack, optional.get().func_222137_e())) {
                        player.func_195066_a(Stats.field_219736_at);
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.CONSUME;
                }
                if (usedItem instanceof ShovelItem) {
                    this.extinguish(state, worldIn, pos);
                    return ActionResultType.SUCCESS;
                }
                if (usedItem == Items.field_151131_as) {
                    this.extinguish(state, worldIn, pos);
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                    return ActionResultType.SUCCESS;
                }
            }
        } else if (itemstack.func_77973_b() instanceof FlintAndSteelItem) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
            itemstack.func_222118_a(1, (LivingEntity)player, action -> action.func_213334_d(handIn));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void extinguish(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = pos.func_177956_o();
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f, false);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        boolean isLit = (Boolean)worldIn.func_180495_p(pos).func_177229_b((Property)LIT);
        if (isLit && !entityIn.func_230279_az_() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof StoveTileEntity) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((StoveTileEntity)tile).getInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT, field_185512_D});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(d0, d1, d2, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.func_177229_b((Property)HorizontalBlock.field_185512_D);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.STOVE_TILE.get()).func_200968_a();
    }
}

